<?php
header('Content-Type: application/json');

$host     = 'http://myservicego.info';
$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$action   = $_GET['action'] ?? '';
$category = $_GET['category_id'] ?? '';
$code     = $_GET['code'] ?? '';
$vod_id   = $_GET['vod_id'] ?? '';
$term     = $_GET['term'] ?? '';
$type     = $_GET['type'] ?? 'vod';

// Verificar si se solicita la acción 'get_code'
if ($action === 'get_code') {
    // Generar un código de activación aleatorio
    $activationCode = strtoupper(bin2hex(random_bytes(4))); // Ejemplo: 4B8B9C0E

    // Devolver el código y la fecha de expiración en formato JSON
    echo json_encode([
        'code' => $activationCode,
        'expires' => null // Expiración indefinida
    ]);
    exit;
}

$actionAlias = [
    'get_movies' => 'get_vod_streams',
    'get_series' => 'get_series',
    'get_streams' => 'get_live_streams',
    'get_series_categories' => 'get_series_categories',
];

$actionReal = $actionAlias[$action] ?? $action;

function getXtreamData($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Establecer un tiempo máximo de ejecución
    curl_setopt($ch, CURLOPT_TIMEOUT, 30); // 30 segundos máximo

    $response = curl_exec($ch);

    // Verificar si ocurrió un error en la solicitud
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        return json_encode(['error' => 'cURL Error: ' . $error_msg]);
    }

    curl_close($ch);
    return $response;
}

switch ($actionReal) {
   case 'get_checking':
    // Ruta al archivo de base de datos SQLite
    $dbFile = 'codigos.db';

    // Crear la base de datos SQLite si no existe
    try {
        $pdo = new PDO("sqlite:$dbFile");
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (PDOException $e) {
        die("Error al conectar a la base de datos: " . $e->getMessage());
    }

    // Consultar el código en la base de datos
    $stmt = $pdo->prepare("SELECT username, password FROM codigos WHERE codigo = ?");
    $stmt->execute([$code]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        // Si el código es válido, devolver el usuario y la contraseña
        $result = [
            'status' => 'success',
            'name' => $result['username'],
            'pass' => $result['password']
        ];
    } else {
        // Si el código no es válido
        $result = ['status' => 'error', 'message' => 'Código inválido'];
    }
    break;

 case 'get_live_streams':
        $list = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_live_streams"), true);
        $filtered = [];
        foreach ((array)$list as $stream) {
            $categories = [];
            if (!empty($stream['category_ids']) && is_array($stream['category_ids'])) {
                $categories = $stream['category_ids'];
            } elseif (!empty($stream['category_id'])) {
                $categories = [$stream['category_id']];
            }

            if ($category === '' || in_array($category, $categories)) {
                $name = strtolower($stream['name'] ?? '');
                $cat = strtolower($stream['category_name'] ?? '');
                $isAdult = (
                    strpos($name, 'xxx') !== false ||
                    strpos($name, 'adult') !== false ||
                    strpos($name, 'erotic') !== false ||
                    strpos($cat, 'xxx') !== false ||
                    strpos($cat, 'adult') !== false ||
                    strpos($cat, 'erotic') !== false
                );

                $filtered[] = [
                    'title' => $stream['name'] ?? 'Sin título',
                    'name' => $stream['name'] ?? '',
                    'stream_id' => $stream['stream_id'] ?? '',
                    'stream_type' => $stream['stream_type'] ?? 'live',
                    'stream_icon' => $stream['stream_icon'] ?? '',
                    'category_id' => $stream['category_id'] ?? '',
                    'look' => $isAdult,
                    'is_adult' => $isAdult,
                    'epg_channel_id' => $stream['epg_channel_id'] ?? '',
                    'tv_archive' => $stream['tv_archive'] ?? 0,
                    'tv_archive_duration' => $stream['tv_archive_duration'] ?? 0,
                    'direct_source' => $stream['direct_source'] ?? '',
                    'custom_sid' => $stream['custom_sid'] ?? '',
                    'thumbnail' => $stream['thumbnail'] ?? ''
                ];
            }
        }
        $result = ['item' => $filtered];
        break;
case 'get_vod_categories':
    // Definir ruta de caché y tiempo de vida
    $cacheDir = 'cache'; // Ruta a la carpeta de caché
    $cacheFile = "$cacheDir/get_vod_categories.json"; // Nombre del archivo de caché para las categorías de VOD
    $cacheLifetime = 24 * 60 * 60; // 24 horas en segundos

    // Verificar si el archivo de caché existe y no ha expirado
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
        // Si la caché está disponible y no ha expirado, leerla y devolverla
        $cachedData = file_get_contents($cacheFile);
        $result = json_decode($cachedData, true);
    } else {
        // Obtener las categorías de VOD desde Xtream API
        $data = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_vod_categories"), true);
        $out = [];

        foreach ((array)$data as $cat) {
            // Eliminar caracteres especiales y símbolos como "▶️" y dejar solo letras y números
            $category_name = preg_replace('/[^a-zA-Z0-9\s]/', '', $cat['category_name']); // Elimina lo que no sea letra, número o espacio
            $category_name = trim($category_name);

            // Eliminar espacio al principio si existe
            if (substr($category_name, 0, 1) == ' ') {
                $category_name = ltrim($category_name); // Eliminar espacio al principio
            }

            // Detectar si la categoría es para adultos
            $is_adult = stripos($category_name, 'xxx') !== false || stripos($category_name, 'adult') !== false;

            // Añadir la categoría al array
            $out[] = [
                'category_id' => $cat['category_id'],
                'category_name' => $category_name,
                'is_adult' => $is_adult
            ];
        }

        // Almacenar los resultados en caché por 24 horas
        $result = ['item' => $out];

        // Crear el directorio de caché si no existe
        if (!is_dir($cacheDir)) {
            mkdir($cacheDir, 0777, true);
        }

        // Guardar los datos en el archivo de caché
        file_put_contents($cacheFile, json_encode($result, JSON_UNESCAPED_UNICODE));
    }
    break;

  

    case 'get_live_categories':
        if ($category !== '') {
            // Si se pasó un category_id, entonces devuelve los canales de esa categoría
            $list = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_live_streams&category_id=$category"), true);
            $result = ['item' => (array)$list];
            break;
        }

        // Si NO se pasó category_id, entonces listar categorías
        $catsRaw = getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_live_categories");
        $cats = json_decode($catsRaw, true);
        $formatted = [];
        foreach ((array)$cats as $cat) {
            // Limpiar los nombres de las categorías
            $category_name = preg_replace('/[^a-zA-Z0-9\s]/', '', $cat['category_name']);  // Eliminar caracteres especiales
            $category_name = trim($category_name);  // Eliminar espacios al principio y al final
            if (substr($category_name, 0, 1) == ' ') {
                $category_name = ltrim($category_name); // Eliminar espacio al principio
            }

            $formatted[] = [
                'category_id' => $cat['category_id'],
                'category_name' => $category_name,
                'is_adult' => (stripos($category_name, 'xxx') !== false || stripos($category_name, 'adult') !== false) ? 1 : 0
            ];
        }
        $result = ['item' => $formatted];
        break;

case 'get_vod_streams':
    // Definir ruta de caché y tiempo de vida
    $category = isset($_GET['category_id']) ? $_GET['category_id'] : ''; // Obtener category_id
    $cacheDir = 'cache'; // Ruta a la carpeta de caché
    
    // Si no se pasa category_id, usamos un archivo de caché general (datos básicos)
    $cacheFile = $category === '' ? "$cacheDir/get_vod_streams.json" : "$cacheDir/get_vod_streams_{$category}.json"; 
    $cacheLifetime = 24 * 60 * 60; // 24 horas en segundos

    // Verificar si el archivo de caché existe y no ha expirado
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
        // Si la caché está disponible y no ha expirado, leerla y devolverla
        $cachedData = file_get_contents($cacheFile);
        $result = json_decode($cachedData, true);
    } else {
        // Obtener las películas con la acción get_vod_streams desde Xtream API
        $apiUrl = "$host/player_api.php?username=$username&password=$password&action=get_vod_streams";
        
        // Si category_id está presente, agregarlo a la URL de la API
        if ($category !== '') {
            $apiUrl .= "&category_id=$category";
        }

        // Realizar la solicitud a la API de Xtream
        $list = json_decode(getXtreamData($apiUrl), true);
        $filtered = [];

        // Verificar si la lista está vacía
        if (empty($list)) {
            $result = ['error' => 'No se encontraron películas para esta categoría.'];
        } else {
            // Filtrar las películas según la categoría
            foreach ((array)$list as $movie) {
                $categories = [];
                if (!empty($movie['category_ids']) && is_array($movie['category_ids'])) {
                    $categories = $movie['category_ids'];
                } elseif (!empty($movie['category_id'])) {
                    $categories = [$movie['category_id']];
                }

                // Filtrar por categoría
                if ($category === '' || in_array($category, $categories)) {
                    // Si no se pasa category_id, solo cargar datos básicos
                    if ($category === '') {
                        $filtered[] = [
                            'name' => $movie['name'] ?? '',
                            'title' => $movie['name'] ?? '',  // Asegurar que title sea igual a name
                            'stream_type' => $movie['stream_type'] ?? 'movie',
                            'stream_id' => $movie['stream_id'] ?? '',
                            'movie_image' => !empty($movie['stream_icon']) ? $movie['stream_icon'] : 'https://i.imgur.com/xuAhAIu.jpeg',
                            'rating' => $movie['rating'] ?? '',
                            'year' => $movie['year'] ?? 'no disponible',
                            'length' => $movie['length'] ?? 0, // Si es proporcionado en la respuesta
                            'is_adult' => $movie['is_adult'] ?? false, // Añadir el campo is_adult
                        ];
                    } else {
                        // Si se pasa category_id, agregar detalles completos de la categoría
                        $vod_id = $movie['stream_id'] ?? '';
                        $plot = $movie['plot'] ?? 'no disponible';
                        $description = $movie['description'] ?? 'no disponible';

                        // Si description está vacío, usar plot en su lugar
                        if ($description === 'no disponible') {
                            $description = $plot;
                        }

                        // Si tanto plot como description están vacíos, hacer una solicitud adicional a get_vod_info
                        if ($plot === 'no disponible' && $description === 'no disponible') {
                            if ($vod_id) {
                                $vod_info = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_vod_info&vod_id=$vod_id"), true);
                                // Extraer datos adicionales desde la respuesta de get_vod_info
                                $plot = $vod_info['info']['plot'] ?? 'no disponible';
                                $description = $vod_info['info']['description'] ?? $plot;  // Si description también está vacío, usar plot

                                // Agregar cast y director de la información adicional
                                $cast = $vod_info['info']['cast'] ?? 'no disponible';
                                $director = $vod_info['info']['director'] ?? 'no disponible';
                            }
                        } else {
                            $cast = $movie['cast'] ?? 'no disponible';
                            $director = $movie['director'] ?? 'no disponible';
                        }

                        // Agregar los detalles completos a la lista de películas
                        $filtered[] = [
                            'name' => $movie['name'] ?? '',
                            'title' => $movie['name'] ?? '',  // Asegurar que title sea igual a name
                            'stream_type' => $movie['stream_type'] ?? 'movie',
                            'stream_id' => $movie['stream_id'] ?? '',
                            'movie_image' => !empty($movie['stream_icon']) ? $movie['stream_icon'] : 'https://i.imgur.com/xuAhAIu.jpeg',
                            'rating' => $movie['rating'] ?? '',
                            'plot' => $plot,
                            'description' => $description,
                            'cast' => $cast,  // Añadir cast
                            'director' => $director,  // Añadir director
                            'releaseDate' => $movie['release_date'] ?? '0',
                            'container_extension' => $movie['container_extension'] ?? 'mp4',
                            'year' => $movie['year'] ?? 'no disponible',
                            'length' => $movie['length'] ?? 0, // Si es proporcionado en la respuesta
                            'is_adult' => $movie['is_adult'] ?? false, // Añadir el campo is_adult
                        ];
                    }
                }
            }

            // Almacenar los resultados en caché por 24 horas
            $result = ['item' => $filtered];
            // Crear el directorio de caché si no existe
            if (!is_dir($cacheDir)) {
                mkdir($cacheDir, 0777, true);
            }
            // Guardar los datos en el archivo de caché
            file_put_contents($cacheFile, json_encode($result, JSON_UNESCAPED_UNICODE));
        }
    }
    break;



case 'get_series':
    // Definir ruta de caché y tiempo de vida
    $category = isset($_GET['category_id']) ? $_GET['category_id'] : ''; // Si no hay category_id, dejamos vacío
    $cacheDir = 'cache'; // Ruta a la carpeta de caché
    
    // Si no se pasa category_id, usamos un archivo de caché general (todas las series)
    $cacheFile = $category === '' ? "$cacheDir/get_series.json" : "$cacheDir/get_series_{$category}.json"; 
    $cacheLifetime = 24 * 60 * 60; // 24 horas en segundos

    // Verificar si el archivo de caché existe y no ha expirado
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
        // Si la caché está disponible y no ha expirado, leerla y devolverla
        $cachedData = file_get_contents($cacheFile);
        $result = json_decode($cachedData, true);
    } else {
        // Obtener la lista de series desde Xtream API (sin filtro de categoría)
        $seriesList = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_series"), true);
        $filtered = [];

        if ($seriesList) {
            foreach ((array)$seriesList as $serie) {
                // Si se pasa category_id, obtenemos detalles (temporadas y episodios)
                if ($category !== '') {
                    $categories = (array)($serie['category_id'] ?? []);
                    if (!in_array($category, $categories)) {
                        continue;  // Si la serie no pertenece a la categoría, se omite
                    }
                }

                // Estructura del JSON
                $serieData = [
                    'num' => $serie['series_id'], // Número único para la serie
                    'name' => $serie['name'], // Nombre de la serie
                    'title' => $serie['name'], // Título de la serie
                    'year' => $serie['year'] ?? '', // Año de la serie (puede ser vacío)
                    'stream_type' => 'series', // Tipo de stream
                    'series_id' => $serie['series_id'], // ID de la serie
                    'cover' => $serie['cover'], // Imagen de portada
                    'plot' => $serie['plot'] ?? '', // Descripción
                    'cast' => $serie['cast'] ?? '', // Reparto
                    'director' => $serie['director'] ?? '', // Director
                    'genre' => $serie['genre'] ?? '', // Género
                    'release_date' => $serie['release_date'] ?? '', // Fecha de estreno
                    'releaseDate' => $serie['release_date'] ?? '', // Fecha de estreno
                    'last_modified' => time(), // Última modificación
                    'rating' => $serie['rating'] ?? '', // Calificación
                    'rating_5based' => $serie['rating_5based'] ?? '', // Calificación de 5
                    'backdrop_path' => !empty($serie['backdrop_path'][0]) ? [$serie['backdrop_path'][0]] : [$serie['cover']] ?? [],
                    'youtube_trailer' => $serie['youtube_trailer'] ?? '', // Trailer de YouTube
                    'episode_run_time' => $serie['episode_run_time'] ?? '', // Duración de episodios
                    'category_id' => $serie['category_id'], // ID de categoría
                    'category_ids' => [$serie['category_id']], // Lista de IDs de categoría
                    'seasons' => [] // Temporadas
                ];

                // Obtener detalles de la serie (temporadas y episodios) solo si hay un category_id
                if ($category !== '') {
                    $infoUrl = "$host/player_api.php?username=$username&password=$password&action=get_series_info&series_id={$serie['series_id']}";
                    $serieInfo = json_decode(getXtreamData($infoUrl), true);

                    if ($serieInfo) {
                        $seasons = [];
                        
                        // Verificar si 'episodes' está presente en el array
                        if (isset($serieInfo['episodes'])) {
                            foreach ((array)$serieInfo['episodes'] as $seasonName => $episodesList) {
                                $episodes = [];
                                foreach ($episodesList as $episode) {
                                    $episodes[] = [
                                        'title' => $episode['title'] ?? '',
                                        'season' => $episode['season'] ?? intval($seasonName),
                                        'episode_num' => $episode['episode_num'] ?? '',
                                        'stream_id' => $episode['id'] ?? '',
                                        'container_extension' => $episode['container_extension'] ?? 'mp4',
                                        'info' => $episode['info'] ?? []
                                    ];
                                }

                                // Añadir temporada al array de temporadas
                                $seasons[] = [
                                    'name' => "Temporada $seasonName",
                                    'stream_id' => $serie['series_id'],
                                    'episodes' => $episodes
                                ];
                            }
                        }

                        // Incluir las temporadas dentro de la serie
                        $serieData['seasons'] = $seasons;
                    }
                }

                // Agregar la serie (detallada o no) a los resultados filtrados
                $filtered[] = $serieData;
            }

            // Almacenar los resultados en caché por 24 horas
            $result = ['item' => $filtered];
            
            // Crear el directorio de caché si no existe
            if (!is_dir($cacheDir)) {
                mkdir($cacheDir, 0777, true);
            }
            
            // Guardar los datos en el archivo de caché
            file_put_contents($cacheFile, json_encode($result, JSON_UNESCAPED_UNICODE));
        } else {
            $result = ['error' => 'No se encontraron series o la respuesta está vacía'];
        }
    }
    break;




case 'get_series_categories':
    // Definir ruta de caché y tiempo de vida
    $cacheDir = 'cache'; // Ruta a la carpeta de caché
    $cacheFile = "$cacheDir/get_series_categories.json"; // Nombre del archivo de caché para las categorías
    $cacheLifetime = 24 * 60 * 60; // 24 horas en segundos

    // Verificar si el archivo de caché existe y no ha expirado
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
        // Si la caché está disponible y no ha expirado, leerla y devolverla
        $cachedData = file_get_contents($cacheFile);
        $result = json_decode($cachedData, true);
    } else {
        // Obtener las categorías de series desde Xtream API
        $seriesCats = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_series_categories"), true);
        $categories = [];

        foreach ((array)$seriesCats as $cat) {
            // Limpiar caracteres especiales y símbolos
            $category_name = preg_replace('/[^a-zA-Z0-9\s]/', '', $cat['category_name']);
            $category_name = trim($category_name);

            // Eliminar espacio inicial si lo hay
            if (substr($category_name, 0, 1) == ' ') {
                $category_name = ltrim($category_name);
            }

            // Detectar si es contenido para adultos
            $is_adult = stripos($category_name, 'xxx') !== false || stripos($category_name, 'adult') !== false ? 1 : 0;

            // Añadir la categoría al array
            $categories[] = [
                'category_id' => $cat['category_id'],
                'category_name' => $category_name,
                'is_adult' => $is_adult
            ];
        }

        // Almacenar los resultados en caché por 24 horas
        $result = ['item' => $categories];
        // Crear el directorio de caché si no existe
        if (!is_dir($cacheDir)) {
            mkdir($cacheDir, 0777, true);
        }
        // Guardar los datos en el archivo de caché
        file_put_contents($cacheFile, json_encode($result, JSON_UNESCAPED_UNICODE));
    }
    break;
























case 'get_search':
    $filtered = [];

    if ($term != '') {
        // Mapeo de los tipos de búsqueda
        $endpointMap = [
            'vod' => 'get_vod_streams', // Endpoint para VOD
            'series' => 'get_series',   // Endpoint para series
            'live' => 'get_live_streams' // Endpoint para live streams
        ];

        // Asignar el endpoint según el tipo
        $apiType = $endpointMap[strtolower($type)] ?? 'get_vod_streams'; // Aseguramos que si no se pasa un tipo, se asigne VOD
        $list = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=$apiType"), true);

        // Verificar si la respuesta de la API es válida
        if (!$list || empty($list)) {
            // Si la respuesta está vacía
            $result = ['item' => []];
            break;
        }

        $count = 1;
        foreach ((array)$list as $item) {
            $name = strtolower($item['name'] ?? '');
            if (stripos($name, $term) !== false) {
                $isAdult = (
                    strpos($name, 'xxx') !== false ||
                    strpos($name, 'adult') !== false ||
                    strpos($name, 'erotic') !== false
                );

                // Si es un live stream
                if ($apiType == 'get_live_streams') {
                    $filtered[] = [
                        'num' => $count++,
                        'name' => $item['name'] ?? 'Sin título',
                        'stream_type' => 'live',
                        'stream_id' => $item['stream_id'] ?? $item['id'] ?? '',
                        'cover' => $item['stream_icon'] ?? $item['cover'] ?? '',
                        'is_adult' => $isAdult ? 1 : 0,
                    ];
                }
                // Si es una serie
                else if ($apiType == 'get_series') {
                    $series_id = $item['series_id'] ?? '';  // series_id para las series
                    $series_info = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password&action=get_series_info&series_id=$series_id"), true);

                    // Verificar si la respuesta de la serie es válida
                    if ($series_info === null) {
                        error_log("Error al obtener la información de la serie para series_id: $series_id");
                        continue; // Si no hay datos válidos, saltamos esta serie
                    }

                    // Obtener detalles adicionales de la serie
                    $description = $series_info['info']['plot'] ?? 'No disponible';
                    $cast = $series_info['info']['cast'] ?? 'No disponible';
                    $director = $series_info['info']['director'] ?? 'No disponible';
                    $releaseDate = $series_info['info']['release_date'] ?? 'No disponible';
                    $durationSec = $series_info['info']['duration_sec'] ?? 0;  // Duración en segundos
                    $lengthInMinutes = floor($durationSec / 60);  // Convertir a minutos

                    // Obtener temporadas
                    $seasons = [];
                    foreach ((array)$series_info['episodes'] as $seasonName => $episodesList) {
                        $episodes = [];
                        foreach ($episodesList as $episode) {
                            // Si 'info' está vacío, asignamos valores predeterminados
                            $episode_info = !empty($episode['info']) ? $episode['info'] : [
                                'plot' => 'No disponible',
                                'cast' => 'No disponible',
                                'director' => 'No disponible'
                            ];
                            $episodes[] = [
                                'title' => $episode['title'] ?? 'Sin título',
                                'season' => $episode['season'] ?? intval($seasonName),
                                'episode_num' => $episode['episode_num'] ?? '',
                                'stream_id' => $episode['id'] ?? '',
                                'container_extension' => $episode['container_extension'] ?? 'mp4',
                                'info' => $episode_info
                            ];
                        }

                        $seasons[] = [
                            'name' => "Temporada $seasonName",
                            'stream_id' => $series_id,
                            'episodes' => $episodes
                        ];
                    }

                    // Agregar la serie con la información detallada
                    $filtered[] = [
                        'num' => $count++,
                        'name' => $item['name'] ?? 'Sin título',
                        'stream_type' => 'series',
                        'stream_id' => $item['series_id'] ?? $item['id'] ?? '',
                        'cover' => $item['stream_icon'] ?? $item['cover'] ?? '',
                        'rating' => $item['rating'] ?? '0',
                        'rating_5based' => $item['rating_5based'] ?? 0,
                        'added' => $item['added'] ?? '',
                        'category_id' => $item['category_id'] ?? '',
                        'container_extension' => $item['container_extension'] ?? '',
                        'custom_sid' => $item['custom_sid'] ?? '',
                        'direct_source' => $item['direct_source'] ?? '',
                        'is_adult' => $isAdult ? 1 : 0,
                        'youtube_trailer' => $item['youtube_trailer'] ?? '',
                        'episode_run_time' => $item['episode_run_time'] ?? 0,
                        'description' => $description,
                        'cast' => $cast,
                        'director' => $director,
                        'release_date' => $releaseDate,
                        'seasons' => $seasons
                    ];
                }
               // Si es VOD (get_vod_streams)
                else if ($apiType == 'get_vod_streams') {
                    // Llamada adicional para obtener la descripción usando vod_id (stream_id)
                    $vod_id = $item['stream_id'] ?? $item['id'] ?? '';
                    $vod_info_url = "$host/player_api.php?username=$username&password=$password&action=get_vod_info&vod_id=$vod_id";
                    
                    // Depuración: Imprimir la URL de la solicitud para comprobar si es correcta
 
                    // Realizar la solicitud a get_vod_info
                    $vod_info = json_decode(getXtreamData($vod_info_url), true);

                    // Verificar si la respuesta de VOD es válida
                    if (isset($vod_info['info']['description'])) {
                        $description = $vod_info['info']['description'];
                    } else {
                        // Si la descripción no está disponible, asignamos 'No disponible'
                        $description = 'No disponible';
                    }

                    // Depuración: Imprimir la respuesta de la API para verificar los datos
 
                    // Agregar la película con la descripción obtenida
                    $filtered[] = [
                        'num' => $count++,
                        'name' => $item['name'] ?? 'Sin título',
                        'stream_type' => 'vod',
                        'stream_id' => $vod_id,
                        'container_extension' => $item['container_extension'] ?? '', // Agregado container_extension

                        'cover' => $item['stream_icon'] ?? $item['cover'] ?? '',
                        'rating' => $item['rating'] ?? '0',
                        'rating_5based' => $item['rating_5based'] ?? 0,
                        'description' => $description, // Asignación de la descripción obtenida
                        'is_adult' => $isAdult ? 1 : 0,
                        'cast' => $vod_info['info']['cast'] ?? 'No disponible',  // Agregar cast
                        'director' => $vod_info['info']['director'] ?? 'No disponible', // Agregar director
                    ];
                }
            }
        }

        // Devolver solo el array de items
        $result = ['item' => $filtered];
    }
    break;


















    default:
        $response = json_decode(getXtreamData("$host/player_api.php?username=$username&password=$password"), true);
        $result = [
            'user_info' => [
                'auth' => $response['user_info']['auth'] ?? 0,
                'username' => $username,
                'password' => $password,
                'status' => $response['user_info']['status'] ?? 'Inactive',
                'exp_date' => $response['user_info']['exp_date'] ?? '',
                'max_connections' => $response['user_info']['max_connections'] ?? '1',
                'allowed_output_formats' => $response['user_info']['allowed_output_formats'] ?? [],
                'active_cons' => 1,
                'message' => 'Autenticado correctamente'
            ],
            'server_info' => $response['server_info'] ?? []
        ];
        break;
}
 echo json_encode($result, JSON_UNESCAPED_UNICODE);
?>
